package com.j_spaces.examples.benchmark;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * lock object for threads synchronization.
 */
public class ObjectLock {
    final private int workerThreads; // number of threads
    final private AtomicInteger startedThreads; // number of started threads

    /**
     * ObjectLock class constructor.
     */
    ObjectLock(int runningThreads) {
        this.workerThreads = runningThreads;
        this.startedThreads = new AtomicInteger(0);
    }

    /**
     * gets the number of program threads.
     */
    public int getWorkerThreads() {
        return workerThreads;
    }

    /**
     * gets the number of threads that already performed start but waiting for notify.
     */
    public int getStartedThreads() {
        return startedThreads.get();
    }

    /**
     * increments the number of threads that already performed start.
     */
    public void incrementStartedThreads() {
        startedThreads.incrementAndGet();
    }
}
