package com.j_spaces.examples.benchmark;

import java.util.LinkedList;

import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionManager;

import com.j_spaces.core.IJSpace;

public abstract class Operation implements Runnable {
    protected BenchmarkConfiguration parameters;

    protected Result operationResultTime = null;

    protected TransactionManager trManager;

    protected int threadID;
    protected ObjectLock objLock;
    protected IJSpace space;
    protected Transaction transaction = null;

    protected long finalTime = 0;
    protected long initialTime = 0;
    protected long initialTimeWFCycle = 0;

    protected LinkedList<Double> threadThroughputTime;

    protected long initialThreadThroughputTime;

    protected long finalThreadThroughputTime;


    private long globalFinalTime;

    private long globalInitialTime;

    protected int min_iter;

    protected int max_iter;

    int rand_iter = 0;
    protected int[] randomCounter = null;

    protected final String OPER_TAKE = "TAKE";
    protected final String OPER_REMOVE = "REMOVE";
    protected final String OPER_READ = "READ";
    protected final String OPER_GET = "GET";
    protected final String OPER_PUT = "PUT";
    protected final String OPER_WRITE = "WRITE";
    protected final String OPER_BENCH = "BENCH";
    protected final String OPER_BENCHMAP = "BENCHMAP";
    protected final String OPER_UPDATE = "UPDATE";
    protected final String OPER_UPDATEMAP = "UPDATEMAP";
    protected final String OPER_WRITE_MULTIPLE = "WRITE MULTIPLE";
    protected final String OPER_READ_MULTIPLE = "READ MULTIPLE";
    protected final String OPER_TAKE_MULTIPLE = "TAKE MULTIPLE";

    //TODO - Individual timers for BENCH operation	
    protected long elapsedTime1;
    protected long elapsedTime2;
    protected long elapsedTime3;

    private static final long MSG_PER_SECOND_RATE = 1000; //rate in msg/sec

    protected BenchmarkOutput benchmarkOutput;

    protected boolean secondOperation = false;

    protected double globalThroughput = 0.0;

    protected Operation(BenchmarkConfiguration parameters, int threadID,
                        ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        this.threadID = threadID;
        this.benchmarkOutput = benchmarkOutput;
        this.parameters = parameters;
        this.objLock = objLock;
        if (parameters.repSpace != null) {
            if (!(this instanceof Write) && !(this instanceof Put) &&
                    !(this instanceof WriteMultiple) && !(this instanceof Notify))
            // also add !(this instanceof JMSNotify) ??
            {
                trManager = parameters.repSpaceTransactionManager;
            }
        } else {
            trManager = parameters.spaceTransactionManager;
        }

        if ((parameters.txIterations != 0)
                || (parameters.isSingleTransaction)) {
            try {
                transaction = createTx();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (parameters.isThreadThroughput) {
            threadThroughputTime = new LinkedList<Double>();
            initialThreadThroughputTime = 0;
            finalThreadThroughputTime = 0;
        }
    }


    protected void say(String mes) {
        System.out.println(Thread.currentThread().getName() + "\t" + mes);
    }


    // creates and returns new transaction
    protected Transaction createTx() throws Exception {
        if (trManager != null) {
            Transaction.Created tCreated = TransactionFactory.create(
                    trManager, 3600 * 1000);

            return tCreated.transaction;
        }

        return null;
    }


    public long getResultTime() {
        if (operationResultTime != null)
            return operationResultTime.getResultTime();

        return -1;
    }

    public long getResultTimeWFCycle() {
        if (operationResultTime != null)
            return operationResultTime.getResultTimeWithoutFirstCycle();

        return -1;
    }


    public void printThreadThroughput(String operation, long operationCounter) {
        printThreadThroughput(operation, operationCounter,
                parameters.threadThroughputIterations);
    }


    public void printThreadThroughput(String operation, long operationCounter, long objectsAmount) {
        objectsAmount = objectsAmount * 1000;

        finalThreadThroughputTime = System.currentTimeMillis();

        long timediff = finalThreadThroughputTime - initialThreadThroughputTime;

        double threadThroughput;
        if (timediff != 0) {
            threadThroughput = objectsAmount / ((double) timediff);
        } else {
            threadThroughput = Integer.MAX_VALUE;
        }

        threadThroughputTime.add(threadThroughput);

        //currentThreadThroughput = BenchmarkUtils.format(threadThroughput);

        say(" " + operation +
                "\titer=" + operationCounter + "\tT_TP=" + BenchmarkUtils.format(threadThroughput) + " oper/sec\t" +
                " Free mem=" + Runtime.getRuntime().freeMemory() / (1024 * 1024) + " MB");

        initialThreadThroughputTime = finalThreadThroughputTime;

        // if (parameters.isGUI)
        if (benchmarkOutput != null)
            benchmarkOutput.addThreadTPSample(String.valueOf(operationCounter), operation, Thread.currentThread().getName(),
                    threadThroughput, BenchmarkUtils.format(globalThroughput),
                    String.valueOf(Runtime.getRuntime().freeMemory() / (1024 * 1024)),
                    secondOperation);
    }

    public void printGlobalOperationThroughput(String operation, long operationCounter) {
        try {
            printGlobalOperationThroughput(operation, operationCounter, 0,
                    parameters.globalThroughputIterations);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//	public void printGlobalOperationThroughput( String operation, long operationCounter, 
//			int repeatCount ) throws Exception
//			{
//					printGlobalOperationThroughput( operation, operationCounter, 
//					                    repeatCount, 
//		                                parameters.globalThroughputIterations );
//			}

    public void printGlobalOperationThroughput(String operation, long operationCounter,
                                               int repeatCount, long objectsAmount) throws Exception {
        objectsAmount = objectsAmount * 1000;

        if (parameters.isAll && (operation.equals(OPER_TAKE) || operation.equals(OPER_REMOVE) || operation.equals(OPER_TAKE_MULTIPLE))) {
            parameters.globalThroughputThirdFinalTime = System.currentTimeMillis();
            globalFinalTime = parameters.globalThroughputThirdFinalTime;
            globalInitialTime = parameters.globalThroughputThirdInitialTime;
        } else if (operation.equals(OPER_WRITE) || operation.equals(OPER_PUT) || operation.equals(OPER_WRITE_MULTIPLE)) {
            parameters.globalThroughputFirstFinalTime = System.currentTimeMillis();
            globalFinalTime = parameters.globalThroughputFirstFinalTime;
            globalInitialTime = parameters.globalThroughputFirstInitialTime;
        } else {
            // GET/READ
            parameters.globalThroughputSecondFinalTime = System.currentTimeMillis();
            globalFinalTime = parameters.globalThroughputSecondFinalTime;
            globalInitialTime = parameters.globalThroughputSecondInitialTime;
        }

        double timediff = globalFinalTime - globalInitialTime;


        if (parameters.isAll && (operation.equals(OPER_TAKE) || operation.equals(OPER_REMOVE) || operation.equals(OPER_TAKE_MULTIPLE))) {
            parameters.globalThroughputThirdInitialTime = parameters.globalThroughputThirdFinalTime;
        } else if (operation.equals(OPER_WRITE) || operation.equals(OPER_PUT) || operation.equals(OPER_WRITE_MULTIPLE)) {
            parameters.globalThroughputFirstInitialTime = parameters.globalThroughputFirstFinalTime;
        } else {
            parameters.globalThroughputSecondInitialTime = parameters.globalThroughputSecondFinalTime;
        }


        if (timediff != 0) {
            globalThroughput = objectsAmount / timediff;
        } else {
            globalThroughput = Integer.MAX_VALUE;
        }

        if (parameters.isAll && (operation.equals(OPER_TAKE) || operation.equals(OPER_REMOVE))) {
            parameters.globalThroughputThirdList.add(globalThroughput);
        } else if (operation.equals(OPER_WRITE) || operation.equals(OPER_PUT) || operation.equals(OPER_WRITE_MULTIPLE)) {
            parameters.globalThroughputFirstList.add(globalThroughput);
        } else {
            parameters.globalThroughputSecondList.add(globalThroughput);
        }
        //currentGlobalThroughput = BenchmarkUtils.format(globalThroughput);

        if (benchmarkOutput != null)
            benchmarkOutput.addGlobalTPSample(String.valueOf(operationCounter), globalThroughput, repeatCount, secondOperation, parameters.isParallel);

        say(" " + operation +
                "\titer=" + operationCounter + "\tG_TP=" + BenchmarkUtils.format(globalThroughput) + " oper/sec\t" +
                " Free mem=" + Runtime.getRuntime().freeMemory() / (1024 * 1024) + " MB");
    }


    public void setSecondOperation(boolean b) {
        secondOperation = b;
    }

    public int[] randomGenerator() {
        int entriesQuantity = max_iter - min_iter + 1;

        randomCounter = new int[entriesQuantity];

        int tmp1 = 0, tmp2 = 0, tmp = 0;

        for (int iter = min_iter, i = 0; iter <= max_iter; iter++, i++) {
            randomCounter[i] = iter;
        }

        for (int i = 0; i < entriesQuantity; i++) {
            tmp1 = (int) (Math.random() * entriesQuantity);

            tmp2 = (int) (Math.random() * entriesQuantity);

            if (tmp1 != tmp2) {
                tmp = randomCounter[tmp1];
                randomCounter[tmp1] = randomCounter[tmp2];
                randomCounter[tmp2] = tmp;
            }
        }

        return randomCounter;
    }


    public abstract void prepare();


    public abstract void doOperation();


    public void run() {
        prepare();

        // wait till all threads started
        synchronized (objLock) {
            objLock.incrementStartedThreads();

            if (objLock.getStartedThreads() < objLock.getWorkerThreads()) {
                try {
                    objLock.wait();
                } catch (InterruptedException ex) {
                    ex.printStackTrace();
                    if (parameters.isGUI)
                        benchmarkOutput.showException("Exception", ex);
                    else
                        System.exit(-1);
                }
            } else {
                objLock.notifyAll();
            }
        }

        boolean firstOp = (this instanceof Write || this instanceof WriteMultiple ||
                this instanceof Put || this instanceof Notify || this instanceof WriteReadUpdateTake ||
                this instanceof PutPutGetRemove || this instanceof JMSWrite || this instanceof JMSNotify);

        long startCycle = 1;
        long endCycle = firstOp ? parameters.writeRepeatTimes : parameters.readRepeatTimes;

        if (this instanceof Take || this instanceof Remove || this instanceof JMSTake)
            endCycle = 1; //after one cycle, there is nothing to take

        initialTime = System.currentTimeMillis();

        for (long cycle = startCycle; cycle <= endCycle; cycle++) {
            //calculate resultTimeWithoutFirstCycle
            if (endCycle > 1 && cycle == 2) {
                initialTimeWFCycle = System.currentTimeMillis();
            }

            //for each next cycle besides initial one create transaction
            //in order to prevent situation that already commited transaction
            //is used
            if (cycle > startCycle && ((parameters.txIterations != 0)
                    || (parameters.isSingleTransaction))) {
                try {
                    transaction = createTx();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            doOperation();

            if (transaction != null && !(this instanceof Notify) && !(this instanceof JMSNotify)) {
                try {
                    transaction.commit();
                } catch (UnknownTransactionException ex) {
                } catch (Exception ex) {
                    ex.printStackTrace();
                    if (parameters.isGUI)
                        benchmarkOutput.showException("Exception", ex);
                    else
                        System.exit(-1);
                }
            }
        }

        finalTime = System.currentTimeMillis();

        operationResultTime = new Result(initialTime, initialTimeWFCycle, finalTime);
    }


    /**
     * Returns the Class object associated with the class or interface with the given string.
     *
     * @return the Class object for the class with the specified name.
     */
    public Object classForName(String className) throws Exception {
        try {
            Class claz = Class.forName(className);
            return claz.newInstance();
        } catch (Exception e) {
            throw e;
        }
    }

    //-writeRate option . rate of messages per sec
    protected void waitWriteRate(String operation, int iter) {
        long finalRateTime = System.currentTimeMillis();
        long elapsedRateTime = finalRateTime - parameters.globalInitialRateTime;
        parameters.globalInitialRateTime = finalRateTime;

        long sleepTime = (MSG_PER_SECOND_RATE - elapsedRateTime);
        String error = "";

        if (sleepTime > 0) {
            try {
                //sleep off whats left
                Thread.sleep(sleepTime);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else
            error = "[X]";

        say(" " + operation +
                "\titer=" + iter + "\tRATE=" + parameters.writeRate + " oper/sec\t" +
                " in=" + elapsedRateTime + " ms. " + error);
    }

/*	
    protected EntryInfo prepareMessageUIDEntryInfo( MessageUID notifyTemplate )
	{
		EntryInfo entryInfo = null;
		String entryUID = null;
		
		
		//create UID info
		entryUID = ClientUIDHandler.createUIDFromName( String.valueOf(notifyTemplate.getCounter()), 
		                                               MessageUID.class.getName() );
		
		entryInfo = new EntryInfo( entryUID, 0 );
		
		notifyTemplate.__setEntryInfo( entryInfo );
		
		return entryInfo;
	}
	*/
}
