package com.j_spaces.examples.benchmark;


import java.util.*;


/**
 * Class OptionHandler Utility class to manage command line argument parsing.
 */
public class OptionHandler {
    private final String m_options;


    /**
     * Construct an option handler for the specified switches.
     *
     * @param options A tokenized string of expected switches delimited by ,
     */
    public OptionHandler(String options) {
        m_options = options;
    }


    /**
     * Construct a map object containing the values and keys of all given the arguments. If no
     * switch was provided and or an invalid switch was provided a usage message would be printed
     * and the an exception of invalid argument would be thrown.
     *
     * @param args The arguments list
     * @return a map object containing the keys and values that matches the switch list
     */
    public Map getOptions(String[] args) throws IllegalArgumentException {
        Map<String, String> argsMap = new HashMap<String, String>();

        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String option = arg.substring(1);
                if (!isValidOption(option)) {
                    throw new IllegalArgumentException("Invalid option : -"
                            + option + ". use -h for help.");
                }
                argsMap.put(option, getArgs(args, i));
            }
        }
        return argsMap;
    }


    private String getArgs(String[] args, int i) {
        StringBuilder entire = new StringBuilder();

        // increase counter of arguments because of args can be without value
        // container JavaSpaces -l host -take -i 10
        i++;

        while (i < args.length && !args[i].startsWith("-")) {
            entire.append(args[i]);
            entire.append(' ');
            i++;
        }

        return entire.toString().trim();
    }


    /**
     * Method tests if the given option is valid.
     *
     * @return 'true' for valid option, 'false' for invalid option.
     */
    public boolean isValidOption(String option) {
        if (m_options.indexOf(option) == -1) {
            return false;
        } else {
            return true;
        }
    }
}

