package com.j_spaces.examples.benchmark;

public class PutPutGetRemove extends Operation {
    IMapDriver map;

    Object putEntry;
    int[] randomArray;

    // constructor
    PutPutGetRemove(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        // Create the distributed cache MAP Interface
        try {
            String mapDriver = System.getProperty(IMapDriver.MAP_DRIVER_PROP);
            if (mapDriver == null) {
                map = new MapDriver();
                map.init(parameters);
            } else {
                map = (IMapDriver) classForName(mapDriver);
                map.init(parameters);
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private void prepareEntry(int iter) {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);

        if (parameters.changeContent) {
            putEntry = adaptor.create(iter, new byte[parameters.messageBuf.length]);
        } else {
            // same content
            parameters.getMessageAdaptor().setCounter(putEntry, iter);
        }
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
        putEntry = adaptor.create(-1, parameters.messageBuf);

        if (parameters.firstOpRange) {
            min_iter = parameters.firstOpRangeFrom;
            max_iter = parameters.firstOpRangeTo - 1;
        } else {
            min_iter = threadID * parameters.numberOfIterations;
            max_iter = min_iter + parameters.numberOfIterations - 1;
        }
    }

    @Override
    public void doOperation() {
        int rateIter, globalTpCounter;
        for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
            prepareEntry(iter);

            long firstOpTime = System.currentTimeMillis();
            map.put(String.valueOf(iter), putEntry/*, parameters.lease*/);
            map.put(String.valueOf(iter), putEntry/*, parameters.lease*/);
            firstOpTime = System.currentTimeMillis() - firstOpTime;
            elapsedTime1 += firstOpTime;

            long secondOpTime = System.currentTimeMillis();
            map.get(String.valueOf(iter));
            secondOpTime = System.currentTimeMillis() - secondOpTime;
            elapsedTime2 += secondOpTime;

            long thirdOpTime = System.currentTimeMillis();
            map.remove(String.valueOf(iter));
            thirdOpTime = System.currentTimeMillis() - thirdOpTime;
            elapsedTime3 += thirdOpTime;

            if (parameters.isWriteRate) {
                rateIter = parameters.globalRateIter.getAndIncrement();
                if (rateIter == 0) {
                    parameters.globalInitialRateTime = System.currentTimeMillis();
                }

                if ((rateIter + 1) % parameters.writeRate == 0) {
                    waitWriteRate(OPER_BENCHMAP, (rateIter + 1));
                }
            }

            // print thread throughput
            if (parameters.isThreadThroughput) {
                if (iter == min_iter) {
                    initialThreadThroughputTime = System.currentTimeMillis();
                }

                if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                    printThreadThroughput(OPER_BENCHMAP, (iter + 1));
                }
            }

            //  print global throughput
            if (parameters.isGlobalThroughput) {
                globalTpCounter = parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                if (globalTpCounter == 0) {
                    parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                }

                if ((globalTpCounter + 1) % parameters.globalThroughputIterations == 0) {
                    printGlobalOperationThroughput(OPER_BENCHMAP, (globalTpCounter + 1));
                }
            }

        }
    }
}
