package com.j_spaces.examples.benchmark;

import java.rmi.RemoteException;

public class Read extends Operation {
    private Object retEntry;
    private Object readTemplate = null;

    // constructor
    Read(BenchmarkConfiguration parameters, int threadID, ObjectLock objectLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objectLock, benchmarkOutput);

        if (parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
            space.snapshot(adaptor.create());
            readTemplate = adaptor.create(-1, null);

            min_iter = threadID * parameters.numberOfIterations;
            max_iter = min_iter + parameters.numberOfIterations - 1;


            if (parameters.secondOpRange) {
                min_iter = parameters.secondOpRangeFrom;
                max_iter = parameters.secondOpRangeTo - 1;
            }

            if (parameters.isRandom) {
                if (!parameters.secondOpRange) {
                    min_iter = 0;
                    max_iter = parameters.numberOfRandomIterations - 1;
                }
                randomCounter = randomGenerator();
            }
        } catch (RemoteException e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private Object prepareReadTemplate(int iter) {
        int id = 0;
        if (parameters.isRandom) {
            id = randomCounter[rand_iter++];
        } else // !isRandom
        {
            id = iter;
        }

        // regular read
        parameters.getMessageAdaptor().setCounter(readTemplate, id);

        return readTemplate;
    }

    @Override
    public void doOperation() {
        Object preparedReadTemplate;

        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                preparedReadTemplate = prepareReadTemplate(iter);

                retEntry = space.read(preparedReadTemplate, transaction, parameters.timeout);

                if (retEntry == null) {
                    if (parameters.isStress && parameters.isParallel)
                        if (!parameters.isAll)    //no take is involved
                            space.read(preparedReadTemplate, transaction, Long.MAX_VALUE);
                        else
                            continue;
                    else
                        throw new Exception("Thread "
                                + Thread.currentThread().getName()
                                + " get NULL entry by READ operation of template");
                }

                if (parameters.delayReadTake != 0) {
                    Thread.sleep(parameters.delayReadTake);
                }

                if (transaction != null) {
                    if (parameters.isSingleTransaction &&
                            ((iter + 1) % parameters.numberOfIterations) == 0) {
                        transaction.commit();
                    } else if (((iter + 1) % parameters.txIterations) == 0) {
                        transaction.commit();

                        if (iter < max_iter) {
                            transaction = createTx();
                        }
                    }
                }

                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_READ, (iter + 1));
                    }
                }

                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput(OPER_READ, (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete READ operation of template");
            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
