package com.j_spaces.examples.benchmark;

import java.rmi.RemoteException;

import net.jini.core.lease.Lease;

public class Take extends Operation {
    private Object retEntry;

    private Object takeTemplate;


    // constructor
    Take(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        retEntry = null;


        if (parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }
    }

    private Object prepareTakeTemplate(int iter) {
        int id;

        if (parameters.isRandom)
            id = randomCounter[rand_iter++];
        else // !isRandom
            id = iter;

        parameters.getMessageAdaptor().setCounter(takeTemplate, id);

        return takeTemplate;
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
            space.snapshot(adaptor.create());

            takeTemplate = adaptor.create(-1, null);

            min_iter = threadID * parameters.numberOfIterations;

            max_iter = min_iter + parameters.numberOfIterations - 1;

            if (parameters.secondOpRange) {
                min_iter = parameters.secondOpRangeFrom;
                max_iter = parameters.secondOpRangeTo - 1;
            }

            if (parameters.isRandom) {
                if (!parameters.secondOpRange) {
                    min_iter = 0;
                    max_iter = parameters.numberOfRandomIterations - 1;
                }
                randomCounter = randomGenerator();
            }
        } catch (RemoteException e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }

    @Override
    public void doOperation() {
        Object preparedTakeTemplate;

        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                preparedTakeTemplate = prepareTakeTemplate(iter);

                retEntry = space.take(preparedTakeTemplate, transaction, parameters.timeout);

                if (retEntry == null) {
                    if (parameters.isStress && parameters.isParallel && parameters.isAll)
                        space.take(preparedTakeTemplate, transaction, Lease.FOREVER);
                    else
                        throw new Exception(
                                "Thread "
                                        + Thread.currentThread().getName()
                                        + " get NULL entry by TAKE operation of template with number "
                                        + iter);
                }

                if (parameters.delayReadTake != 0) {
                    Thread.sleep(parameters.delayReadTake);
                }

                if (transaction != null) {
                    if (parameters.isSingleTransaction &&
                            ((iter + 1) % parameters.numberOfIterations) == 0) {
                        transaction.commit();
                    } else if (((iter + 1) % parameters.txIterations) == 0) {
                        transaction.commit();

                        if (iter < max_iter) {
                            transaction = createTx();
                        }
                    }
                }

                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_TAKE, (iter + 1));
                    }
                }

                if (parameters.isGlobalThroughput) {
                    if (parameters.isAll) {
                        globalTpCounter = parameters.globalThroughputThirdOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            parameters.globalThroughputThirdInitialTime = System.currentTimeMillis();
                        }

                        if ((globalTpCounter + 1) %
                                parameters.globalThroughputIterations == 0) {
                            printGlobalOperationThroughput(OPER_TAKE, (globalTpCounter + 1));
                        }
                    } else {
                        globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                        }

                        if ((globalTpCounter + 1) %
                                parameters.globalThroughputIterations == 0) {
                            printGlobalOperationThroughput(OPER_TAKE, (globalTpCounter + 1));
                        }
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete TAKE operation of template");

            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
