package com.j_spaces.examples.benchmark;

import java.rmi.RemoteException;

public class TakeMultiple extends Operation {
    Object takeTemplate;
    Object[] retEntries;

    // constructor
    TakeMultiple(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);

        takeTemplate = adaptor.create();

        if (parameters.repSpace != null)
            space = parameters.repSpace;
        else
            space = parameters.space;

        try {
            space.snapshot(adaptor.create());
        } catch (RemoteException e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }

    @Override
    public void doOperation() {
        try {
            int globalTpCounter;
            for (int batch = 1; batch <= parameters.numOfBatches && BenchmarkCommand.START_STOP_FLAG; batch++) {
                if (batch == 1) {
                    initialThreadThroughputTime = System.currentTimeMillis();
                    parameters.globalThroughputThirdInitialTime = initialThreadThroughputTime;
                    parameters.globalThroughputSecondInitialTime = initialThreadThroughputTime;
                }

                if (parameters.timeout > 0) {
                    //sleep with timeout and after this try to call takeMultiple() again
                    Thread.sleep(parameters.timeout);
                }

                retEntries = space.takeMultiple(takeTemplate, transaction,
                        parameters.batchAmount);

                if (retEntries.length != parameters.batchAmount) {
                    throw new Exception(

                            "Thread " + Thread.currentThread().getName()
                                    + "\nTAKE MULTIPLE operation returned " + retEntries.length +
                                    " entries, while expecting  " +
                                    parameters.batchAmount + " within batch# " + batch +
                                    ".\nTry to increase timeout if performing a parallel operation.");

                }

                if (parameters.delayReadTake != 0) {
                    Thread.sleep(parameters.delayReadTake);
                }

                if (transaction != null) {
                    if (parameters.isSingleTransaction &&
                            ((batch * parameters.batchAmount) % parameters.numberOfIterations) == 0) {
                        transaction.commit();
                    } else if (((batch * parameters.batchAmount) % parameters.txIterations) == 0) {
                        transaction.commit();

                        if (batch < parameters.numOfBatches) {
                            transaction = createTx();
                        }
                    }
                }

                // print thread throughput
                if (parameters.isThreadThroughput) {
                    printThreadThroughput(OPER_TAKE_MULTIPLE, batch, parameters.batchAmount);
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter =
                            parameters.globalThroughputThirdOperationCounter.getAndIncrement();
                    printGlobalOperationThroughput(OPER_TAKE_MULTIPLE,
                            (globalTpCounter + 1), 0, parameters.batchAmount);
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete TAKE MULTIPLE operation of batch");
            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
