package com.j_spaces.examples.benchmark;

import net.jini.core.entry.Entry;

import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicLong;

public class WriteMultiple extends Operation {
    private Object[] entries;
    private MessageAdaptor adaptor;
    //counter must be static in order not to be reset between different threads,
    //in such case each thread creates each own instances of WriteMultiple
    private static AtomicLong globalCounter = new AtomicLong();

    // constructor
    WriteMultiple(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        adaptor = MessageAdaptors.getByCode(parameters.messageType);
        entries = adaptor.isEntry()
                ? new Entry[parameters.batchAmount]
                : new Object[parameters.batchAmount];

        if (parameters.isNotify && parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }
    }

    @Override
    public void prepare() {
        adaptor = MessageAdaptors.getByCode(parameters.messageType);
        /*
        //don't reset counter between threads of benchmark
        //reset counter if we know that only single thread runs it
        if( parameters.threadCount == 1 ) {
            globalCounter.set(0);
        }*/
        try {
            space.snapshot(adaptor.create());
        } catch (RemoteException e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }

    private void prepareArray() {
        for (int count = 0; count < parameters.batchAmount; count++) {
            byte[] content =
                    parameters.changeContent ? new byte[parameters.messageBuf.length + count] : parameters.messageBuf;

            long counter = globalCounter.incrementAndGet();
            entries[count] = adaptor.create(counter, content);
        }
    }

    @Override
    public void doOperation() {
        try {
            int globalTpCounter;
            int batchesCount = parameters.numOfBatches;
            for (int batch = 1; batch <= batchesCount && BenchmarkCommand.START_STOP_FLAG; batch++) {
                if (batch == 1) {
                    initialThreadThroughputTime = System.currentTimeMillis();
                    parameters.globalThroughputFirstInitialTime = initialThreadThroughputTime;
                }
                //fix GS-11739: we need to set unique counter value in order to perform write and not update
                prepareArray();

                space.writeMultiple(entries, transaction, parameters.lease);

                if (parameters.delayWrite != 0) {
                    Thread.sleep(parameters.delayWrite);
                }

                if (transaction != null) {
                    if (parameters.isSingleTransaction &&
                            ((batch * parameters.batchAmount) % parameters.numberOfIterations) == 0) {
                        transaction.commit();
                    } else if (((batch * parameters.batchAmount) % parameters.txIterations) == 0) {
                        transaction.commit();

                        if (batch < parameters.numOfBatches) {
                            transaction = createTx();
                        }
                    }
                }

                // print thread throughput
                if (parameters.isThreadThroughput) {
                    printThreadThroughput(OPER_WRITE_MULTIPLE, batch, parameters.batchAmount);
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter =
                            parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                    printGlobalOperationThroughput(OPER_WRITE_MULTIPLE,
                            (globalTpCounter + 1), 0, parameters.batchAmount);
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete WRITE MULTIPLE operation of batch");
            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }

}
