package com.j_spaces.examples.benchmark;

import java.rmi.RemoteException;

public class WriteReadUpdateTake extends Operation {
    private Object writeEntry;

    // constructor
    WriteReadUpdateTake(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        if (parameters.isNotify && parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }
    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = parameters.getMessageAdaptor();
            writeEntry = adaptor.create(-1, parameters.messageBuf);
            parameters.space.snapshot(adaptor.create());

            if (parameters.firstOpRange) {
                min_iter = parameters.firstOpRangeFrom;
                max_iter = parameters.firstOpRangeTo - 1;
            } else {
                min_iter = threadID * parameters.numberOfIterations;
                max_iter = min_iter + parameters.numberOfIterations - 1;
            }
        } catch (RemoteException e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private void prepareEntry(long iter) {
        long id;

        if (parameters.isNotify)
            id = threadID;
        else
            id = iter;

        parameters.getMessageAdaptor().setCounter(writeEntry, id);

        //different content per iteration
        if (parameters.changeContent)
            parameters.getMessageAdaptor().setPayload(writeEntry, new byte[parameters.messageBuf.length]);
    }

    @Override
    public void doOperation() {
        try {
            int rateIter, globalTpCounter;
            for (long iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                prepareEntry(iter);

                long firstOpTime = System.currentTimeMillis();
                space.write(writeEntry, transaction,
                        parameters.lease);
                space.update(writeEntry, transaction, parameters.lease, 60000);
                firstOpTime = System.currentTimeMillis() - firstOpTime;
                elapsedTime1 += firstOpTime;

                long secondOpTime = System.currentTimeMillis();
                writeEntry = space.read(writeEntry, transaction, parameters.timeout);
                secondOpTime = System.currentTimeMillis() - secondOpTime;
                elapsedTime2 += secondOpTime;

                long thirdOpTime = System.currentTimeMillis();
                writeEntry = space.take(writeEntry, transaction, parameters.timeout);
                thirdOpTime = System.currentTimeMillis() - thirdOpTime;
                elapsedTime3 += thirdOpTime;


                if (parameters.delayWrite != 0) {
                    Thread.sleep(parameters.delayWrite);
                }

                if (transaction != null) {
                    if (parameters.isSingleTransaction &&
                            ((iter + 1) % parameters.numberOfIterations) == 0) {
                        transaction.commit();
                    } else if (((iter + 1) % parameters.txIterations) == 0) {
                        transaction.commit();

                        if ((iter + 1) < max_iter) {
                            transaction = createTx();
                        }
                    }
                }

                if (parameters.isWriteRate) {
                    rateIter = parameters.globalRateIter.getAndIncrement();
                    if (rateIter == 0) {
                        parameters.globalInitialRateTime = System.currentTimeMillis();
                    }

                    if ((rateIter + 1) % parameters.writeRate == 0) {
                        waitWriteRate(OPER_BENCH, (rateIter + 1));
                    }
                }

                // print thread throughput
                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_BENCH, (iter + 1));
                    }
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput(OPER_BENCH, (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete WRITE operation of entry");

            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
