package com.j_spaces.examples.benchmark.adaptors;

import javax.jms.JMSException;

import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.messages.MessageJMS;

public class MessageJMSAdaptor extends MessageAdaptor<MessageJMS> {
    public short getCode() {
        return MessageAdaptors.CODE_JMS;
    }

    public String getName() {
        return "jms";
    }

    public String getLabel() {
        return "JMS";
    }

    public String getDescription() {
        return "com.j_spaces.jms.GSSimpleMessageImpl, a basic JMS message which implements java.io.Externalizable and javax.jms.Message interfaces.";
    }

    @Override
    public String getUsageInfo() {
        return super.getUsageInfo() + "For basic JMS send or sync/async receive, use Write for JMS send, Take for JMS sync receive or Notify for JMS async receive.";
    }


    public int getGroup() {
        return MessageAdaptors.GROUP_JMS;
    }

    @Override
    public boolean isJMS() {
        return true;
    }

    public MessageJMS create() {
        try {
            return new MessageJMS();
        } catch (JMSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MessageJMS create(long counter, byte[] content) {
        try {
            return new MessageJMS(content);
        } catch (JMSException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setCounter(MessageJMS instance, long counter) {
    }

    @Override
    public void setPayload(MessageJMS instance, byte[] payload) {
        instance.Body = payload;
    }
}
