package com.j_spaces.examples.benchmark.adaptors;

import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.messages.MessagePOJO;

public class MessagePOJOAdaptor extends MessageAdaptor<MessagePOJO> {
    public short getCode() {
        return MessageAdaptors.CODE_POJO;
    }

    public String getName() {
        return "pojo";
    }

    public String getLabel() {
        return "POJO";
    }

    public String getDescription() {
        return "Plain Java object.";
    }

    public int getGroup() {
        return MessageAdaptors.GROUP_SERIALIZABLE;
    }

    public MessagePOJO create() {
        return new MessagePOJO();
    }

    @Override
    public void setCounter(MessagePOJO instance, long counter) {
        instance.setCounter(counter);
    }

    @Override
    public void setPayload(MessagePOJO instance, byte[] payload) {
        instance.setContent(payload);
    }
}
