package com.j_spaces.examples.benchmark.adaptors;

import com.j_spaces.examples.benchmark.MessageAdaptor;
import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.messages.MessagePOJOExternalizable;

public class MessagePOJOExternalizableAdaptor extends MessageAdaptor<MessagePOJOExternalizable> {
    public short getCode() {
        return MessageAdaptors.CODE_POJO_EXTERNALIZABLE;
    }

    public String getName() {
        return "pojo-ext";
    }

    public String getLabel() {
        return "POJO Externalizable";
    }

    public String getDescription() {
        return "Plain Java object implements java.io.Externalizable interface.";
    }

    public int getGroup() {
        return MessageAdaptors.GROUP_EXTERNALIZABLE;
    }

    public MessagePOJOExternalizable create() {
        return new MessagePOJOExternalizable();
    }

    public MessagePOJOExternalizable create(long counter, byte[] content) {
        MessagePOJOExternalizable result = super.create(counter, content);
        result.initList();
        return result;
    }

    @Override
    public void setCounter(MessagePOJOExternalizable instance, long counter) {
        instance.setCounter(counter);
    }

    @Override
    public void setPayload(MessagePOJOExternalizable instance, byte[] payload) {
        instance.setContent(payload);
    }
}
