package com.j_spaces.examples.benchmark.adaptors;

import com.j_spaces.examples.benchmark.MessageAdaptors;
import com.j_spaces.examples.benchmark.messages.MessagePOJOExternalizableFifo;

public class MessagePOJOExternalizableFifoAdaptor extends MessagePOJOExternalizableAdaptor {
    public short getCode() {
        return MessageAdaptors.CODE_POJO_EXTERNALIZABLE_FIFO;
    }

    public String getName() {
        return "pojo-ext-fifo";
    }

    public String getLabel() {
        return "POJO Externalizable FIFO";
    }

    public String getDescription() {
        return "Plain Java object implements java.io.Externalizable interface with FIFO.";
    }

    @Override
    public boolean isFifo() {
        return true;
    }

    public MessagePOJOExternalizableFifo create() {
        return new MessagePOJOExternalizableFifo();
    }
}
