package com.j_spaces.examples.benchmark.messages;

import net.jini.core.entry.Entry;

/**
 * class Message is a nested class ( not an inner one - by definition are not allowed to be static
 * or contain static members) This class creates the message entry to space. Object implements
 * net.jini.core.entry.Entry interface
 */
public class Message implements Entry {
    private static final long serialVersionUID = -7801081082421261299L;

    public byte[] m_content;
    public Long m_counter;

    final private static String[] INDEXED_FIELDS = {"m_counter"};

    public Message() {
    }

    @Override
    public String toString() {
        return getClass() + "_" + m_counter + "_" + m_content;
    }

    public static String[] __getSpaceIndexedFields() {
        return INDEXED_FIELDS;
    }
}
 
