package com.j_spaces.examples.benchmark.messages;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.GregorianCalendar;
import java.util.List;

import com.gigaspaces.annotation.pojo.SpaceId;
import com.gigaspaces.annotation.pojo.SpaceProperty;
import com.j_spaces.examples.benchmark.MessageUtilities;

/**
 * Plain Java object implements java.io.Externalizable interface. Contains additional field with a
 * complex list, therefore should NOT be compared with the following objects: entry, pojo, uid,
 * fifo, jms
 */
public class MessagePOJOExternalizable implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long counter = -1;
    private byte[] content;
    private List<GregorianCalendar> list;

    public MessagePOJOExternalizable() {
    }

    @SpaceId
    @SpaceProperty(nullValue = "-1")
    public long getCounter() {
        return counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public byte[] getContent() {
        return content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void initList() {
        if (content != null)
            list = MessageUtilities.generateData(10);
    }

    public List<GregorianCalendar> getList() {
        return list;
    }

    public void setList(List<GregorianCalendar> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return getClass() + "_" + counter + "_" + content;
    }

    public void readExternal(ObjectInput in) throws IOException,
            ClassNotFoundException {
        counter = (Long) in.readLong();

        Integer m_content_length = in.readInt();

        if (m_content_length > 0) {
            content = new byte[m_content_length.intValue()];
            in.read(content, 0, m_content_length.intValue());
        }
        boolean islist = in.readBoolean();
        if (islist) {
            list = MessageUtilities.copyDataFromObjectInputToList(in);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {

        out.writeLong(counter);

        if (content != null) {
            out.writeInt(content.length);
            out.write(content, 0, content.length);
        } else {
            out.writeInt(0);
        }

        MessageUtilities.copyDataFromListToObjectOutput(list, out);
    }
}